within Modelica_LinearSystems2.WorkInProgress.Tests.care;
function care6 "Example 6 from Benner benchmarks"
  extends Modelica.Icons.Function;
  import MatricesMSL = Modelica.Math.Matrices;
  import Modelica_LinearSystems2.Math.Matrices;
  input String outputFile = "";

protected
Real A[30,30]=[ -4.3280000000000003e+000,  1.7140000000000000e-001,  5.3760000000000003e+000,  4.0160000000000002e+002, -7.2460000000000002e+002, -1.9330000000000001e+000,  1.0200000000000000e+000, -9.8199999999999998e-001,  9.9900000000000000e-001,  1.5209999999999999e+000, -4.0620000000000003e+000,  9.5670000000000002e+000,  1.0080000000000000e+001, -6.0170000000000001e-001, -1.3120000000000001e-001,  9.6019999999999994e-002, -4.5699999999999998e-002,  0.0000000000000000e+000, -4.5160000000000002e+002,  0.0000000000000000e+000,  0.0000000000000000e+000, -1.0580000000000000e+002,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -4.4019999999999998e-001, -5.6429999999999998e+000,  1.2750000000000000e+002, -2.3350000000000000e+002, -4.3430000000000001e+002,  2.6590000000000000e+001,  2.0400000000000000e+000, -2.5920000000000001e+000,  1.1320000000000000e+001,  1.0900000000000000e+001, -4.0709999999999997e+000, -5.7389999999999997e-002, -6.0629999999999995e-001, -7.4880000000000002e-002, -5.9360000000000002e-001, -9.6019999999999994e-002,  1.1140000000000000e-001,  0.0000000000000000e+000, -5.4610000000000002e+002,  0.0000000000000000e+000,  0.0000000000000000e+000, -6.5750000000000002e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  1.0380000000000000e+000,  6.0730000000000004e+000, -1.6500000000000000e+002, -4.4829999999999997e+000,  1.0490000000000000e+003, -8.2450000000000003e+001, -5.3140000000000001e+000,  5.0970000000000004e+000, -9.3889999999999998e-003,  1.3519999999999999e-001,  5.6379999999999999e+000,  2.2460000000000001e-002,  1.7970000000000000e-001,  2.4070000000000001e-002,  1.1000000000000001e+000,  2.7430000000000000e-002,  2.1529999999999999e-001,  0.0000000000000000e+000,  1.3620000000000000e+003,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.3460000000000001e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  5.3039999999999998e-001, -1.0860000000000000e-001,  1.3130000000000001e+002, -5.7829999999999995e+002,  1.0200000000000000e+002, -9.2400000000000002e+000, -1.1459999999999999e+000, -2.4079999999999999e+000, -3.0810000000000000e+000, -4.5289999999999999e+000,  5.7069999999999999e+000, -2.3460000000000000e-001, -2.1110000000000002e+000, -2.4600000000000000e-001, -4.6860000000000002e-001, -3.2229999999999998e-001,  3.2619999999999999e-001,  0.0000000000000000e+000,  2.0800000000000000e+002,  0.0000000000000000e+000,  0.0000000000000000e+000, -2.8879999999999999e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  8.4759999999999992e-003, -1.5630000000000002e-002,  5.6020000000000000e-002,  1.5730000000000000e+000, -1.0050000000000001e+001,  1.9520000000000001e-001, -8.8039999999999993e-003, -2.1100000000000001e-002,  2.0899999999999998e-003, -5.2560000000000003e-002, -4.0770000000000001e-002, -9.1819999999999992e-003, -5.1780000000000000e-002,  3.4250000000000003e-002,  4.9950000000000003e-003, -1.2560000000000000e-002,  9.9480000000000002e-003,  0.0000000000000000e+000, -9.8390000000000001e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  5.0690000000000002e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  8.3499999999999996e-001, -1.2489999999999999e-002, -3.5670000000000000e-002, -6.0740000000000005e-001,  3.7649999999999999e+001, -1.9789999999999999e+001, -1.8129999999999999e-001, -2.9520000000000001e-002, -1.9529999999999999e-002, -1.6220000000000001e-001, -6.4390000000000003e-003, -2.3460000000000002e-002, -2.2009999999999999e-001, -2.5139999999999999e-002, -3.7490000000000002e-003, -3.3509999999999998e-002,  2.7279999999999999e-002,  0.0000000000000000e+000,  7.1620000000000005e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  9.6080000000000005e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  6.7679999999999996e-001, -1.2640000000000000e-002, -9.6829999999999999e-002, -3.5670000000000002e-001,  8.0239999999999995e+001, -8.2390000000000005e-002, -2.0469999999999999e+001, -3.9280000000000002e-002,  1.8780000000000002e-002, -2.1290000000000001e-001, -9.3369999999999998e-003, -3.1440000000000003e-002, -2.9189999999999999e-001, -3.3700000000000001e-002,  8.8730000000000003e-002, -4.4580000000000002e-002,  1.7160000000000002e-002,  0.0000000000000000e+000,  7.1709999999999994e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  8.5709999999999997e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -9.6960000000000005e-002,  8.6660000000000004e-001,  1.6870000000000001e+001,  1.0509999999999999e+000, -1.0230000000000000e+002,  2.9660000000000000e+001,  5.9430000000000005e-001, -1.9969999999999999e+001,  2.2530000000000001e-002,  1.7010000000000000e-001,  8.3710000000000000e-003,  2.6450000000000001e-002,  2.5600000000000001e-001,  2.8350000000000000e-002, -3.7490000000000002e-002,  3.6350000000000000e-002, -7.7410000000000007e-002,  0.0000000000000000e+000, -1.4119999999999999e+002,  0.0000000000000000e+000,  0.0000000000000000e+000, -8.2150000000000001e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -8.7849999999999994e-003, -1.6360000000000000e-002,  1.8470000000000000e-001,  2.1690000000000001e-001, -8.4199999999999999e+000,  7.0030000000000003e-001,  5.6660000000000002e-002,  6.6230000000000002e+000, -4.9990000000000002e+001,  6.7599999999999993e-002,  3.9460000000000001e+001,  4.9909999999999998e-003,  8.9829999999999993e-002,  5.3489999999999996e-003,  0.0000000000000000e+000,  1.3720000000000000e-002,  3.8550000000000001e-002,  0.0000000000000000e+000, -7.7100000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -4.3709999999999999e-002,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.2980000000000001e-004, -2.4300000000000000e-004,  2.7179999999999999e-003,  3.2139999999999998e-003, -1.2460000000000000e-001,  1.0370000000000001e-002,  8.3949999999999997e-004,  9.8119999999999999e-002, -6.6659999999999997e-001, -6.6569999999999996e-001,  5.8470000000000000e-001,  6.6539999999999997e-005,  1.3470000000000001e-003,  7.1310000000000007e-005,  0.0000000000000000e+000,  2.0570000000000001e-004,  5.7070000000000005e-004,  0.0000000000000000e+000, -1.1440000000000000e-001,  0.0000000000000000e+000,  0.0000000000000000e+000, -6.3590000000000001e-004,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.2070000000000001e+000, -6.7169999999999996e+000,  2.6260000000000002e+001,  1.2490000000000000e+001, -1.2690000000000000e+003,  1.0300000000000000e+002,  7.4800000000000004e+000,  3.6840000000000003e+001,  2.8539999999999999e-001,  2.3319999999999999e+000, -4.7649999999999999e+001,  3.4060000000000001e-001,  3.0649999999999999e+000,  3.6240000000000000e-001, -4.3430000000000002e-001,  4.6810000000000002e-001,  5.7270000000000003e+000,  0.0000000000000000e+000, -1.7450000000000000e+003,  0.0000000000000000e+000,  0.0000000000000000e+000, -8.9399999999999995e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -2.7300000000000001e-002, -4.5390000000000003e-001, -5.2719999999999999e+001,  1.9880000000000001e+002, -2.8090000000000000e+001,  2.2429999999999999e+000,  1.7940000000000000e-001,  9.7500000000000000e+000, -9.6270000000000007e+000, -9.5570000000000004e+000,  3.8479999999999997e+001, -5.0009999999999998e+001,  1.0110000000000000e-001,  1.2030000000000001e-002, -4.6859999999999999e-002,  1.7149999999999999e-002,  1.3919999999999999e-001,  0.0000000000000000e+000, -2.4300000000000001e+001,  0.0000000000000000e+000,  0.0000000000000000e+000, -2.7360000000000001e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.2060000000000000e-003, -2.0170000000000000e-002, -2.3430000000000000e+000,  8.8350000000000009e+000, -1.2480000000000000e+000,  9.9750000000000005e-002,  8.0590000000000002e-003,  4.3330000000000002e-001, -4.2780000000000001e-001, -4.2449999999999999e-001,  1.7100000000000000e+000, -2.0000000000000000e+000, -1.9960000000000000e+000,  5.3490000000000005e-004, -1.9989999999999999e-003,  7.5440000000000001e-004,  6.1720000000000004e-003,  0.0000000000000000e+000, -1.0820000000000001e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -1.1830000000000000e-002,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.6130000000000000e-001, -2.4690000000000001e-001, -2.4050000000000001e+001,  2.3379999999999999e+001,  1.4830000000000001e+002,  1.6379999999999999e+000,  1.3850000000000001e-001,  4.4880000000000004e+000, -4.4139999999999997e+000, -4.3540000000000001e+000,  1.7660000000000000e+001, -3.1130000000000000e+000, -3.0179999999999998e+000, -1.9770000000000000e+001, -4.9990000000000000e-002,  1.5089999999999999e-002,  6.7769999999999997e-002,  0.0000000000000000e+000,  1.6600000000000001e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  3.9800000000000002e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.2440000000000000e-002,  3.0200000000000001e-002, -1.1980000000000000e-001, -4.8210000000000003e-002,  5.5750000000000002e+000, -4.5250000000000001e-001,  1.9809999999999999e+001,  1.2490000000000000e-001, -1.1270000000000000e-003, -6.7600000000000004e-003,  1.8350000000000002e-002, -9.9810000000000003e-004, -1.3469999999999999e-002, -1.0700000000000000e-003, -2.0000000000000000e+001, -2.0569999999999998e-003,  1.8799999999999999e-003,  0.0000000000000000e+000,  9.1470000000000002e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -8.2410000000000005e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
 -1.6530000000000000e+000,  1.8310000000000000e+000, -3.8220000000000001e+000,  1.1340000000000001e+002,  3.4139999999999998e+002, -2.7340000000000000e+001, -2.0400000000000000e+000, -6.1660000000000004e-001,  5.0039999999999996e-001, -1.4369999999999999e-001, -2.4159999999999999e+000, -1.0730000000000001e-001, -1.0780000000000001e+000,  3.0530000000000001e+001,  1.9890000000000001e+001, -5.0159999999999997e+001,  1.6769999999999999e-001,  0.0000000000000000e+000,  4.3580000000000001e+002,  0.0000000000000000e+000,  0.0000000000000000e+000, -5.9939999999999998e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -5.0000000000000000e+002, -6.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -3.6000000000000000e+003, -7.0800000000000000e+002, -1.0672000000000000e+002,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -1.2000000000000000e+004, -5.2400000000000000e+003, -1.5000000000000000e+002,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  3.3299999999999997e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -3.3299999999999997e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -2.0000000000000000e+001,  0.0000000000000000e+000,  0.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  6.4500000000000002e-001,  6.4500000000000002e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  1.0000000000000000e+000;
  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -8.9400000000000002e-001, -8.9400000000000002e-001,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000,  0.0000000000000000e+000, -3.0599999999999999e-001, -1.8600000000000001e+000];

  Real B[30,3]=[0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                5.000e+02,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  3.600e+03,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  1.200e+04;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0;
                0.0,  0.0,  0.0];

  Real C[5,30]=[4.865e-01,   -6.741e-01,   5.392e+00,   9.542e+01,   2.403e+01,   1.052e+01,   8.190e-01,   -4.492e-01,   5.195e-01,   8.437e-01,   -1.863e+00,   5.709e-02,   4.815e-01,   3.428e+00,   2.161e+00,   7.681e-02,   -6.777e-02,   0.000e+00,   -4.205e+02,   0.000e+00,   0.000e+00,   3.297e+01,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00;
                1.383e-02,   2.789e-06,   0.000e+00,   0.000e+00,   -1.081e-02,   -5.545e-05,   4.722e-05,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   1.282e-04,   0.000e+00,   3.353e-01,   0.000e+00,   0.000e+00,   6.804e-01,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00;
                0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   1.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00;
                7.418e-05,   5.496e-06,   4.790e-06,   1.478e-04,   -1.504e-02,   -6.503e-05,   8.820e-05,   4.999e-06,   3.434e-06,   2.727e-05,   1.128e-06,   4.002e-06,   3.673e-05,   4.290e-06,   -4.958e-06,   5.609e-06,   1.030e-06,   0.000e+00,   -1.193e-02,   0.000e+00,   0.000e+00,   -5.806e-03,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00;
                1.538e-05,   1.201e-04,   -2.579e-03,   -1.609e-04,   1.618e-02,   -1.071e-03,   -9.561e-05,   -5.503e-06,   -3.732e-06,   -2.996e-05,   -1.234e-06,   -4.380e-06,   -4.024e-05,   -4.721e-06,   5.324e-06,   -6.103e-06,   8.109e-06,   0.000e+00,   2.328e-02,   0.000e+00,   0.000e+00,   1.178e-04,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00,   0.000e+00];

  Real R[3,3]=identity(3);
  Real G[30,30]=B*transpose(B);
  Real Q[30,30]=transpose(C)*C;
  Real H[60,60]=[A,-G; -Q,-transpose(A)];
  Real condH=MatricesMSL.conditionNumber(H);
  Real normH=MatricesMSL.norm(H, 2);
  Real condX1;
  Real normX1;
  Real condX2;
  Real normX2;
  Real condX3;
  Real normX3;
  Real Qr1[30,30];
  Real Qr2[30,30];
  Real Qr3[30,30];
  Real deltaQ1;
  Real deltaQ2;
  Real deltaQ3;

public
  output Real X1[30,30]=Matrices.care(A, B, R, Q, false);
  output Real X2[30,30]=Matrices.care(A, B, R, Q, true);

  output Real X3[30,30]=[1.1314520623027671e-002,    -1.6107914360228366e-004,     1.0125148710909534e-001,     1.0607123005840252e-001,     2.1391559007082854e+000,    -5.3013044708812972e-003,     5.9603743184771987e-003,     1.2610227664547665e-003,    -1.8717987377899620e-003,    -2.2561160424941010e-003,     4.3035170075349603e-003,    -2.5751944752821143e-004,     3.8311953516901812e-003,     4.0709208507935232e-002,     2.6300093602768280e-002,     2.8084085764500964e-005,     1.2633130362166875e-003,     1.6212991928128692e-005,    -5.1700691175234459e+000,    -4.5965796496117969e-002,    -1.7055974012332117e-004,     5.2107653698599132e-001,     5.9039810386038675e-003,     2.5781927216810587e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     2.4731346392712914e-017,     3.7509607815033465e-017;
 -1.6107914360228366e-004,     2.4157491443241299e-003,    -3.2015766997613423e-002,    -8.8611325180730505e-002,     2.0141819898897190e-001,    -2.9451273326253597e-002,    -1.2693648726770927e-003,     1.5429066365809621e-006,    -4.8199235070527200e-004,    -4.2314522845959585e-004,     2.2994568213888407e-003,    -1.6356714154880224e-004,     1.0219174671594854e-003,    -4.1220288115707635e-003,    -2.5065447083500387e-003,    -1.3947453543740917e-004,    -1.8676072818446309e-004,    -4.8969478986915494e-006,     9.6931093362681714e-002,    -7.6817208964863777e-003,    -3.9910154909747358e-005,    -2.8605378636211883e-002,     6.7748306797468414e-004,     3.6373384941241013e-006,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     1.3179862066559472e-017,     4.7702183721099802e-017;
  1.0125148710909534e-001,    -3.2015766997613423e-002,     1.6946402727294536e+000,     2.1689040043683305e+000,     1.8200749429328468e+001,     3.2026263570129376e-001,     6.1686357494969521e-002,    -5.4538715472363025e-002,    -7.1987587851942989e-003,     8.0444533277696517e-003,    -2.0131282784866152e-002,    -1.3676697979232745e-003,     2.2054914447808181e-002,     4.6415276589845278e-001,     2.9675759466017282e-001,     2.3294992311815388e-003,    -9.6412126525501703e-004,    -5.9261469393990914e-006,    -5.0900402415947994e+001,    -2.9011103537033928e-001,    -7.8343817526871492e-004,     5.1720999078969827e+000,     3.0620099850064988e-002,     8.7291076709474888e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     3.8422885438084180e-017,     8.1109719439219436e-018;
  1.0607123005840252e-001,    -8.8611325180730505e-002,     2.1689040043683305e+000,     8.0187244581683856e+000,     1.2250257082107950e+001,     1.2191665516829480e+000,     1.1209899571371032e-001,    -9.1570806309904440e-002,     3.1772422241598181e-002,     6.6417405731577728e-002,    -1.6913208871441468e-001,     3.6564604001257765e-003,     4.9615568185418048e-002,     5.9318281179557975e-001,     3.7425585653330884e-001,     7.3046185971569737e-003,    -6.2216264936675158e-003,     2.8678115354033595e-007,    -6.8740402318687273e+001,    -1.6406777542282691e-001,    -3.5710832825739156e-004,     6.0879545090596761e+000,     1.6436899492756271e-002,     4.2647265039928257e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     5.7660849811843378e-018,    -9.9334334076166023e-018;
  2.1391559007082854e+000,     2.0141819898897190e-001,     1.8200749429328468e+001,     1.2250257082107950e+001,     5.0700363030881539e+002,    -5.9599971843770927e+000,     9.7331566850286644e-001,    -4.2576231507301759e-001,    -4.4991051789574699e-001,    -5.4208161930943799e-001,     1.0244367738498048e+000,    -9.5287660783881456e-002,    -2.0434385826631637e-002,     8.3767393504301388e+000,     5.4191661683840149e+000,    -1.4137965544241626e-002,     1.9018898400861954e-002,    -1.0729782670434202e-003,    -1.1451125418349934e+003,    -1.1245328874522540e+001,    -4.3154498600316601e-002,     1.0587639122248761e+002,     1.2002402403132373e+000,     4.8612476643694899e-003,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     4.4542517811037866e-015,    -2.5567826001282688e-015;
 -5.3013044708812972e-003,    -2.9451273326253597e-002,     3.2026263570129376e-001,     1.2191665516829480e+000,    -5.9599971843770927e+000,     4.5247717621080591e-001,     1.5087127330881068e-002,     1.3487883733422499e-002,     1.0272758284758272e-002,     2.2351016976336242e-002,    -3.5118523983982554e-002,     2.5573246671023193e-003,     1.7187359698277227e-002,     7.2088636470338495e-003,     2.5630163488559038e-003,     2.0386393485413200e-003,     5.8121455254000892e-003,     1.2856549386410188e-004,     4.7078806018554138e+000,     1.5807796912499550e-001,     7.0881843306397341e-004,    -1.9347778254501627e-001,    -1.4042129092639431e-002,    -6.0928879739184912e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -1.0716432158645074e-016,     3.8143430366120274e-016;
  5.9603743184771987e-003,    -1.2693648726770927e-003,     6.1686357494969521e-002,     1.1209899571371032e-001,     9.7331566850286644e-001,     1.5087127330881068e-002,     4.3725367321334032e-003,     2.4771843170698690e-003,    -6.9156741696970749e-004,    -4.6353024965527988e-004,     1.7669001116361019e-003,    -7.7459933905512241e-005,     2.0855856066857928e-003,     2.2577974200174347e-002,     1.4472886109789182e-002,     7.6458860592387235e-005,     1.0992683470281641e-003,     1.4917372943272113e-005,    -3.0274139835655745e+000,    -2.5728660944654758e-002,    -1.0396755297956248e-004,     2.8582929235246757e-001,     3.1688779990072472e-003,     1.4931677407201184e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     3.9951908089463261e-017,     1.5447036783328321e-016;
  1.2610227664547665e-003,     1.5429066365809621e-006,    -5.4538715472363025e-002,    -9.1570806309904440e-002,    -4.2576231507301759e-001,     1.3487883733422499e-002,     2.4771843170698690e-003,     1.8541549587043831e-002,    -1.1739686379868886e-003,    -1.3641288396525175e-003,     1.0899194969507028e-002,     8.8198574924541404e-005,     5.2918987571072135e-003,    -8.0927646089878815e-003,    -5.0062449818770571e-003,    -2.8270389757516259e-005,     4.2013086672945217e-003,     5.8539010643643644e-005,     8.1015487477043502e-001,    -5.7083939589918876e-003,    -4.9432902344155901e-005,    -1.9953589563148542e-002,     2.6225620906442674e-003,     1.8241863468107298e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -9.3920344523586209e-017,     8.5685678733633103e-017;
 -1.8717987377899620e-003,    -4.8199235070527200e-004,    -7.1987587851942989e-003,     3.1772422241598181e-002,    -4.4991051789574699e-001,     1.0272758284758272e-002,    -6.9156741696970749e-004,    -1.1739686379868886e-003,     7.3899541882960999e-004,     9.7268447234455531e-004,    -2.4726592323675760e-003,     1.0065835583547995e-004,     2.3361694150332313e-004,    -5.7351498967773834e-003,    -3.7682315746656566e-003,     4.8588714689092320e-005,    -3.4209400054982931e-004,    -3.2295703852028390e-006,     8.0942947486176953e-001,     1.0803595672628539e-002,     4.2867756407817412e-005,    -8.4510736946567494e-002,    -1.3635257015676774e-003,    -6.1001444823862882e-006,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     1.6252774176231897e-017,     1.0721648367251547e-017;
 -2.2561160424941010e-003,    -4.2314522845959585e-004,     8.0444533277696517e-003,     6.6417405731577728e-002,    -5.4208161930943799e-001,     2.2351016976336242e-002,    -4.6353024965527988e-004,    -1.3641288396525175e-003,     9.7268447234455531e-004,     2.4221259678494450e-002,    -3.2559523370696095e-003,    -1.5119069001175210e-004,     5.7898205891273296e-003,    -3.7310667060018654e-003,    -2.5143955308998423e-003,     1.2797874890013814e-004,    -4.7589034336605203e-004,    -5.1154740454952569e-006,     9.9922335037105969e-001,     1.8663165933441611e-002,     8.8209981082483627e-005,    -9.3978774590296299e-002,    -2.5351467435352315e-003,    -1.3965611527607245e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -2.4616766378584793e-015,     2.8690626416851757e-016;
  4.3035170075349603e-003,     2.2994568213888407e-003,    -2.0131282784866152e-002,    -1.6913208871441468e-001,     1.0244367738498048e+000,    -3.5118523983982554e-002,     1.7669001116361019e-003,     1.0899194969507028e-002,    -2.4726592323675760e-003,    -3.2559523370696095e-003,     2.0280733821810056e-002,    -3.4855177990517517e-004,     9.5848007720599989e-004,     8.8007348982472571e-003,     5.9773999569269071e-003,    -1.7933280651198050e-004,     2.1791300324801050e-003,     1.8386308223611988e-005,    -1.7239431161019216e+000,    -3.3695601389783121e-002,    -1.4600366102304421e-004,     1.7093735038587315e-001,     4.1808192799757740e-003,     1.9896273924677094e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -1.0197508916769204e-017,     3.1404681324394296e-017;
 -2.5751944752821143e-004,    -1.6356714154880224e-004,    -1.3676697979232745e-003,     3.6564604001257765e-003,    -9.5287660783881456e-002,     2.5573246671023193e-003,    -7.7459933905512241e-005,     8.8198574924541404e-005,     1.0065835583547995e-004,    -1.5119069001175210e-004,    -3.4855177990517517e-004,     3.9954878482285753e-005,     2.0885241129553764e-005,    -1.1695768688093995e-003,    -7.6211234279950526e-004,     9.7432203911548479e-006,     3.9436204671319287e-005,     1.1882789523586905e-006,     1.8847885079438437e-001,     2.3234657621013289e-003,     9.3399676562331805e-006,    -1.4273403003222855e-002,    -1.7568117237244392e-004,    -5.7159845221000377e-007,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -5.6808449112854693e-018,     1.2676825063240146e-018;
  3.8311953516901812e-003,     1.0219174671594854e-003,     2.2054914447808181e-002,     4.9615568185418048e-002,    -2.0434385826631637e-002,     1.7187359698277227e-002,     2.0855856066857928e-003,     5.2918987571072135e-003,     2.3361694150332313e-004,     5.7898205891273296e-003,     9.5848007720599989e-004,     2.0885241129553764e-005,     1.4496225854746241e-002,     5.2615044640261848e-003,     3.4745198594603563e-003,     9.6332964170953172e-005,     1.9653086080665492e-003,     3.4402553803178094e-005,    -1.2011896200819400e-001,     4.5527324123781684e-003,     2.9933026083526343e-005,     7.4309997819240914e-002,     1.0486050969080603e-003,     6.6835817627296278e-006,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     1.3627760920868991e-016,     1.7474147279208624e-016;
  4.0709208507935232e-002,    -4.1220288115707635e-003,     4.6415276589845278e-001,     5.9318281179557975e-001,     8.3767393504301388e+000,     7.2088636470338495e-003,     2.2577974200174347e-002,    -8.0927646089878815e-003,    -5.7351498967773834e-003,    -3.7310667060018654e-003,     8.8007348982472571e-003,    -1.1695768688093995e-003,     5.2615044640261848e-003,     1.6918386835510865e-001,     1.0887494987664253e-001,     3.2988128364902313e-004,     1.2668579203300753e-003,     5.1112562821432639e-006,    -2.0995713381307340e+001,    -1.6849980717144863e-001,    -5.9556245198296939e-004,     2.0331302535356479e+000,     1.8774543296634194e-002,     7.1908438162286107e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     1.1764931107964995e-017,     1.4201186666442584e-017;
  2.6300093602768280e-002,    -2.5065447083500387e-003,     2.9675759466017282e-001,     3.7425585653330884e-001,     5.4191661683840149e+000,     2.5630163488559038e-003,     1.4472886109789182e-002,    -5.0062449818770571e-003,    -3.7682315746656566e-003,    -2.5143955308998423e-003,     5.9773999569269071e-003,    -7.6211234279950526e-004,     3.4745198594603563e-003,     1.0887494987664253e-001,     7.0085606717242843e-002,     2.0432359900814800e-004,     8.5967995543925237e-004,     3.8552948159692070e-006,    -1.3489243867616850e+001,    -1.0857170263947999e-001,    -3.8291689043109769e-004,     1.3104753634161017e+000,     1.2175588068605296e-002,     4.6665737216639170e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -3.7395858037309767e-017,     2.7887822922726449e-017;
  2.8084085764500964e-005,    -1.3947453543740917e-004,     2.3294992311815388e-003,     7.3046185971569737e-003,    -1.4137965544241626e-002,     2.0386393485413200e-003,     7.6458860592387235e-005,    -2.8270389757516259e-005,     4.8588714689092320e-005,     1.2797874890013814e-004,    -1.7933280651198050e-004,     9.7432203911548479e-006,     9.6332964170953172e-005,     3.2988128364902313e-004,     2.0432359900814800e-004,     1.1522364469447503e-005,     8.3969766582294545e-006,     3.1009973634852648e-007,     2.0258199123508978e-003,     7.7542059420616970e-004,     4.1592812007601974e-006,     1.9066906678958215e-003,    -6.8655449071811678e-005,    -4.0633578246446710e-007,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -1.0857823245749045e-018,    -1.8919694970494328e-018;
  1.2633130362166875e-003,    -1.8676072818446309e-004,    -9.6412126525501703e-004,    -6.2216264936675158e-003,     1.9018898400861954e-002,     5.8121455254000892e-003,     1.0992683470281641e-003,     4.2013086672945217e-003,    -3.4209400054982931e-004,    -4.7589034336605203e-004,     2.1791300324801050e-003,     3.9436204671319287e-005,     1.9653086080665492e-003,     1.2668579203300753e-003,     8.5967995543925237e-004,     8.3969766582294545e-006,     1.1248843190088545e-003,     1.6848704256803877e-005,    -1.2631435243154646e-001,    -2.9062458146660239e-003,    -1.5177606081916443e-005,     3.5056718608943362e-002,     9.8721407362008370e-004,     6.0582024980891251e-006,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     3.0048892601270165e-017,     5.2687958070133744e-018;
  1.6212991928128692e-005,    -4.8969478986915494e-006,    -5.9261469393990914e-006,     2.8678115354033595e-007,    -1.0729782670434202e-003,     1.2856549386410188e-004,     1.4917372943272113e-005,     5.8539010643643644e-005,    -3.2295703852028390e-006,    -5.1154740454952569e-006,     1.8386308223611988e-005,     1.1882789523586905e-006,     3.4402553803178094e-005,     5.1112562821432639e-006,     3.8552948159692070e-006,     3.1009973634852648e-007,     1.6848704256803877e-005,     2.7348013246573624e-007,     1.4000978172497831e-003,     6.0454240473467485e-006,    -3.3471593867896176e-009,     3.3349675177426119e-004,     1.1399384893671311e-005,     7.7322807067334181e-008,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     4.9233696788889253e-019,     1.1189639290919407e-019;
 -5.1700691175234459e+000,     9.6931093362681714e-002,    -5.0900402415947994e+001,    -6.8740402318687273e+001,    -1.1451125418349934e+003,     4.7078806018554138e+000,    -3.0274139835655745e+000,     8.1015487477043502e-001,     8.0942947486176953e-001,     9.9922335037105969e-001,    -1.7239431161019216e+000,     1.8847885079438437e-001,    -1.2011896200819400e-001,    -2.0995713381307340e+001,    -1.3489243867616850e+001,     2.0258199123508978e-003,    -1.2631435243154646e-001,     1.4000978172497831e-003,     3.1063068982509326e+003,     3.0809068577522883e+001,     1.3037089944501426e-001,    -2.6314565449024428e+002,    -2.9298475965462991e+000,    -1.2725789141350191e-002,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -4.3557104966212494e-015,     2.2389774180420039e-015;
 -4.5965796496117969e-002,    -7.6817208964863777e-003,    -2.9011103537033928e-001,    -1.6406777542282691e-001,    -1.1245328874522540e+001,     1.5807796912499550e-001,    -2.5728660944654758e-002,    -5.7083939589918876e-003,     1.0803595672628539e-002,     1.8663165933441611e-002,    -3.3695601389783121e-002,     2.3234657621013289e-003,     4.5527324123781684e-003,    -1.6849980717144863e-001,    -1.0857170263947999e-001,     7.7542059420616970e-004,    -2.9062458146660239e-003,     6.0454240473467485e-006,     3.0809068577522883e+001,     4.1484603360400596e-001,     2.0606238804963869e-003,    -2.3134609524667074e+000,    -3.3569911851717649e-002,    -1.5964177205051195e-004,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -5.6694198840441077e-017,     2.1878965010101277e-017;
 -1.7055974012332117e-004,    -3.9910154909747358e-005,    -7.8343817526871492e-004,    -3.5710832825739156e-004,    -4.3154498600316601e-002,     7.0881843306397341e-004,    -1.0396755297956248e-004,    -4.9432902344155901e-005,     4.2867756407817412e-005,     8.8209981082483627e-005,    -1.4600366102304421e-004,     9.3399676562331805e-006,     2.9933026083526343e-005,    -5.9556245198296939e-004,    -3.8291689043109769e-004,     4.1592812007601974e-006,    -1.5177606081916443e-005,    -3.3471593867896176e-009,     1.3037089944501426e-001,     2.0606238804963869e-003,     1.1257646479250110e-005,    -8.6808443683323994e-003,    -1.4383979506220649e-004,    -7.2617348783136431e-007,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -2.6920650566938837e-019,     3.6924816915117691e-020;
  5.2107653698599132e-001,    -2.8605378636211883e-002,     5.1720999078969827e+000,     6.0879545090596761e+000,     1.0587639122248761e+002,    -1.9347778254501627e-001,     2.8582929235246757e-001,    -1.9953589563148542e-002,    -8.4510736946567494e-002,    -9.3978774590296299e-002,     1.7093735038587315e-001,    -1.4273403003222855e-002,     7.4309997819240914e-002,     2.0331302535356479e+000,     1.3104753634161017e+000,     1.9066906678958215e-003,     3.5056718608943362e-002,     3.3349675177426119e-004,    -2.6314565449024428e+002,    -2.3134609524667074e+000,    -8.6808443683323994e-003,     2.5401068405580375e+001,     2.6905064473872486e-001,     1.1264445861486410e-003,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -3.3079348743294432e-016,    -9.2375448564113312e-017;
  5.9039810386038675e-003,     6.7748306797468414e-004,     3.0620099850064988e-002,     1.6436899492756271e-002,     1.2002402403132373e+000,    -1.4042129092639431e-002,     3.1688779990072472e-003,     2.6225620906442674e-003,    -1.3635257015676774e-003,    -2.5351467435352315e-003,     4.1808192799757740e-003,    -1.7568117237244392e-004,     1.0486050969080603e-003,     1.8774543296634194e-002,     1.2175588068605296e-002,    -6.8655449071811678e-005,     9.8721407362008370e-004,     1.1399384893671311e-005,    -2.9298475965462991e+000,    -3.3569911851717649e-002,    -1.4383979506220649e-004,     2.6905064473872486e-001,     4.1179358828019189e-003,     2.0167722981492082e-005,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -1.3162833585273572e-017,    -4.9958044693886117e-018;
  2.5781927216810587e-005,     3.6373384941241013e-006,     8.7291076709474888e-005,     4.2647265039928257e-005,     4.8612476643694899e-003,    -6.0928879739184912e-005,     1.4931677407201184e-005,     1.8241863468107298e-005,    -6.1001444823862882e-006,    -1.3965611527607245e-005,     1.9896273924677094e-005,    -5.7159845221000377e-007,     6.6835817627296278e-006,     7.1908438162286107e-005,     4.6665737216639170e-005,    -4.0633578246446710e-007,     6.0582024980891251e-006,     7.7322807067334181e-008,    -1.2725789141350191e-002,    -1.5964177205051195e-004,    -7.2617348783136431e-007,     1.1264445861486410e-003,     2.0167722981492082e-005,     1.0624744775475083e-007,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,    -9.5123461457722745e-020,    -2.6768544836468317e-020;
  0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000;
  0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000;
  0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000;
  0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000;
  2.4731346392712914e-017,     1.3179862066559472e-017,     3.8422885438084180e-017,     5.7660849811843378e-018,     4.4542517811037866e-015,    -1.0716432158645074e-016,     3.9951908089463261e-017,    -9.3920344523586209e-017,     1.6252774176231897e-017,    -2.4616766378584793e-015,    -1.0197508916769204e-017,    -5.6808449112854693e-018,     1.3627760920868991e-016,     1.1764931107964995e-017,    -3.7395858037309767e-017,    -1.0857823245749045e-018,     3.0048892601270165e-017,     4.9233696788889253e-019,    -4.3557104966212494e-015,    -5.6694198840441077e-017,    -2.6920650566938837e-019,    -3.3079348743294432e-016,    -1.3162833585273572e-017,    -9.5123461457722745e-020,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000;
  3.7509607815033465e-017,     4.7702183721099802e-017,     8.1109719439219436e-018,    -9.9334334076166023e-018,    -2.5567826001282688e-015,     3.8143430366120274e-016,     1.5447036783328321e-016,     8.5685678733633103e-017,     1.0721648367251547e-017,     2.8690626416851757e-016,     3.1404681324394296e-017,     1.2676825063240146e-018,     1.7474147279208624e-016,     1.4201186666442584e-017,     2.7887822922726449e-017,    -1.8919694970494328e-018,     5.2687958070133744e-018,     1.1189639290919407e-019,     2.2389774180420039e-015,     2.1878965010101277e-017,     3.6924816915117691e-020,    -9.2375448564113312e-017,    -4.9958044693886117e-018,    -2.6768544836468317e-020,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000,     0.0000000000000000e+000];
  output Real ku1=Matrices.Internal.k_care_u(A, Q, G, X1);
  output Real ku2=Matrices.Internal.k_care_u(A, Q, G, X2);
  output Real ku3=Matrices.Internal.k_care_u(A, Q, G, X3);
algorithm
  Qr1 := X1*G*X1-transpose(A)*X1-X1*A;
  Qr2 := X2*G*X2-transpose(A)*X2-X2*A;
  Qr3 := X3*G*X3-transpose(A)*X3-X3*A;
  deltaQ1 := MatricesMSL.norm(Q-Qr1)/MatricesMSL.norm(Q);
  deltaQ2 := MatricesMSL.norm(Q-Qr2)/MatricesMSL.norm(Q);
  deltaQ3 := MatricesMSL.norm(Q-Qr3)/MatricesMSL.norm(Q);
  condX1 := MatricesMSL.conditionNumber(X1);
  normX1 := MatricesMSL.norm(X1, 2);
  condX2 := MatricesMSL.conditionNumber(X2);
  normX2 := MatricesMSL.norm(X2, 2);
  condX3 := MatricesMSL.conditionNumber(X3);
  normX3 := MatricesMSL.norm(X3, 2);

  Modelica.Utilities.Streams.print("Solution X1 without subsequent Newton refinement",outputFile);
  Modelica.Utilities.Streams.print(Matrices.printMatrix(X1, 16, "X1"),outputFile);
  Modelica.Utilities.Streams.print("Solution X2 with subsequent Newton refinement",outputFile);
  Modelica.Utilities.Streams.print(Matrices.printMatrix(X2, 16, "X2"),outputFile);
  Modelica.Utilities.Streams.print("MATLAB solution X3",outputFile);
  Modelica.Utilities.Streams.print(Matrices.printMatrix(X3, 16, "X3"),outputFile);
  Modelica.Utilities.Streams.print("\n normH = " + String(normH),outputFile);
  Modelica.Utilities.Streams.print("\n condH = " + String(condH),outputFile);
  Modelica.Utilities.Streams.print("\n normX1 = " + String(normX1),outputFile);
  Modelica.Utilities.Streams.print("\n condX1 = " + String(condX1),outputFile);
  Modelica.Utilities.Streams.print("\n ku1 = " + String(ku1),outputFile);
  Modelica.Utilities.Streams.print("\n normX2 = " + String(normX2),outputFile);
  Modelica.Utilities.Streams.print("\n condX2 = " + String(condX2),outputFile);
  Modelica.Utilities.Streams.print("\n ku2 = " + String(ku2),outputFile);
  Modelica.Utilities.Streams.print("\n normX3 = " + String(normX3),outputFile);
  Modelica.Utilities.Streams.print("\n condX3 = " + String(condX3),outputFile);
  Modelica.Utilities.Streams.print("\n ku3 = " + String(ku3),outputFile);
  Modelica.Utilities.Streams.print("\n deltaQ1 = " + String(deltaQ1),outputFile);
  Modelica.Utilities.Streams.print("\n deltaQ2 = " + String(deltaQ2),outputFile);
  Modelica.Utilities.Streams.print("\n deltaQ3 = " + String(deltaQ3),outputFile);

end care6;
